--This file contains some examples in how to use music in our game engine

--FUNCTIONS:
--  set_master_volume(volume)    [0.0 - 1.0]
--  set_music_volume(volume)     [0.0 - 1.0]
--  set_sfx_volume(volume)       [0.0 - 1.0]
--  play_sfx(path)               [path + filename]
--  add_music(path)              [path + filename]
--  reset_music()
--  remove_music(filename)       [filename]
--  set_audio_pause(bool is_paused) [is_paused]
--  is_audio_paused              {is_paused}
--  create_sound(name, music, radius, x, y)  [name] [path+filename] [radius] [x] [y]
--  create_sound_effect(name, sound_name, delay, is_looping) [name] [sound_name] [delay] [is_looping]
--  create_music(name, music)   [name] [music_name]
--  create_sound_variety_collection(name,radius, x, y) [name] [radius] [x] [y]
--  add_sound_to_variety_collection(name, music) [name] [music]

if(parameter == 0) then
lua:add_music("data/music/enya_background.ogg") -- path + filename

lua:play_sfx("data/music/effect_stereo.ogg")  -- path + filename

timer_adv(5,"data/scripts/test/music_examples.lua",false,1)
end

if(parameter == 1) then
    if(lua:is_audio_paused() == false) then
        lua:set_audio_pause(true)
        timer_adv(5,"data/scripts/test/music_examples.lua",false,1)
    else
        lua:set_audio_pause(false)
        timer_adv(10,"data/scripts/test/music_examples.lua",false,2)
    end
end

if(parameter == 2) then
    lua:reset_music()
    lua:add_music("data/music/enya_background.ogg")
    timer_adv(15,"data/scripts/test/music_examples.lua",false,3)
end

if(parameter == 3) then
    lua:remove_music("enya_background.ogg")
    
    lua:create_sound("test_sound","data/music/effect_stereo.ogg", 500.0, 200.0, 0.0)
    lua:create_sound_effect("test_sound_effect", "test_sound", 15.0, true)
    g_level.upload("test_sound_effect",1)
    
    lua:create_sound_variety_collection("test_sound1", -500.0, 200.0, 0.0)
    lua:add_sound_to_variety_collection("test_sound1","data/music/effect_stereo.ogg")
    lua:create_sound_effect("test_sound_effect1", "test_sound1", 25.0, true)
    g_level.upload("test_sound_effect1",1)
end